import 'dart:developer';

import '../../../../config.dart';
import '../../../../models/service_details_model.dart';

class AddOnServiceCard extends StatelessWidget {
  final additionalServices;
  final bool isContain, isDelete, isIconShow;
  final int? index, additionalServicesLength;
  final GestureTapCallback? deleteTap, onTap;
  const AddOnServiceCard(
      {super.key,
      this.additionalServices,
      this.isDelete = false,
      this.isContain = false,
      this.index,
      this.additionalServicesLength,
      this.deleteTap,
      this.onTap,
      this.isIconShow = true});

  @override
  Widget build(BuildContext context) {
    // final media = additionalServices is Map<String, dynamic>
    //     ? additionalServices['media'] ?? []
    //     : additionalServices.media ?? [];

    final title = additionalServices is Map<String, dynamic>
        ? additionalServices['title']
        : additionalServices.title;

    final price = additionalServices is Map<String, dynamic>
        ? additionalServices['price']
        : additionalServices.price;

    final rawMedia = additionalServices is Map<String, dynamic>
        ? additionalServices['media']
        : additionalServices.media;

// Always ensure media is a list
    final media = rawMedia is List ? rawMedia : [];

    final imageUrl = media.isNotEmpty
        ? (media[0] is String
            ? media[0]
            : media[0] is Map
                ? media[0]['original_id'] ?? ''
                : media[0] is AdditionalServiceMedia
                    ? (media[0] as AdditionalServiceMedia).originalId ?? ''
                    : '')
        : '';

    log("imageUrl::${imageUrl.runtimeType}");
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Row(
          children: [
            imageUrl!.isNotEmpty
                ? CommonImageLayout(
                    radius: 8,
                    width: Sizes.s50,
                    height: Sizes.s50,
                    image: imageUrl.toString() ?? '',
                    assetImage: eImageAssets.noImageFound2,
                  )
                : Container(
                    height: Sizes.s52,
                    width: Sizes.s52,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(30),
                        image: DecorationImage(
                            image: AssetImage(eImageAssets.noImageFound1),
                            fit: BoxFit.contain))),
            const HSpace(Sizes.s10),
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(title,
                        maxLines: 2,
                        style: appCss.dmDenseMedium14
                            .textColor(appColor(context).darkText))
                    .width(Sizes.s180),
                const VSpace(Sizes.s8),
                Text(
                    symbolPosition
                        ? "${getSymbol(context)}${currency(context).currencyVal * price}"
                        : "${currency(context).currencyVal * price}${getSymbol(context)}",
                    style: appCss.dmDenseMedium14
                        .textColor(appColor(context).darkText)),
              ],
            )
          ],
        ),
        if (isIconShow)
          isDelete
              ? CommonArrow(
                  arrow: eSvgAssets.delete,
                  svgColor: appColor(context).red,
                  onTap: deleteTap,
                  color: appColor(context).red.withOpacity(0.1))
              : isContain
                  ? SvgPicture.asset(
                      eSvgAssets.tickCircle,
                      height: Sizes.s20,
                    ).inkWell(onTap: onTap)
                  : SvgPicture.asset(eSvgAssets.add,
                          colorFilter: ColorFilter.mode(
                              appColor(context).primary, BlendMode.srcIn))
                      .paddingAll(1)
                      .decorated(
                          shape: BoxShape.circle,
                          border: Border.all(color: appColor(context).primary))
                      .inkWell(onTap: onTap)
      ],
    )
        .inkWell(onTap: onTap)
        .paddingSymmetric(horizontal: Insets.i15, vertical: Sizes.s12)
        .boxBorderExtension(context,
            bColor: isContain
                ? appColor(context).primary.withOpacity(.10)
                : appColor(context).stroke,
            color: isContain
                ? appColor(context).primary.withOpacity(.10)
                : appColor(context).whiteBg)
        .paddingOnly(
            bottom: index != additionalServicesLength ? Insets.i15 : 0);
  }
}
